/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* -----------------------------------------------------------------------
 * File: timcheck.h
 * Author: Christoph Schmidt 6.07.98
 * Purpose: This file contains the function prototypes 
 *          for the timing checker
 * ----------------------------------------------------------------------- */

#ifndef TIMCHECK_H_INCLUDED
#define TIMCHECK_H_INCLUDED

#include <typedefs.h>
#include <tichdefs.h> 

#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------
 * PCI Timing Checker Functions
 * -----------------------------------------------------------------------
 */


CLI b_errtype EXPORT BestTimCheckMaskSet(              /* @tcmset */
    b_handletype  handle,
    b_signaltype  signal,                         /* @sig */
    b_int32       value                           /* @val  */
    );



CLI b_errtype EXPORT BestTimCheckBitMaskSet(      /* @tcbmset */
    b_handletype  handle,
    b_int32       bitposition,                    /* @pos */
    b_int32       value                           /* @val  */
    );


CLI b_errtype EXPORT BestTimCheckMaskGet(              /* @tcmget */
    b_handletype  handle,
    b_signaltype  signal,                         /* @sig */
    b_int32 *     value                           /* #RETURN "Value= %08lx\\h\n" */
    );

CLI b_errtype EXPORT BestTimCheckBitMaskGet(      /* @tcbmget */
    b_handletype  handle,
    b_int32       bitposition,                    /* @pos */
    b_int32 *     value                           /* #RETURN "Value= %d\n" */
    );


CLI b_errtype EXPORT BestTimCheckDefaultSet(       /* @tcdefset */
    b_handletype handle
    );


CLI b_errtype EXPORT BestTimCheckErrGet(           /* @tcerrget */
    b_handletype handle,                           
    b_int32 bitposition,                           /* @pos */                      
    b_int32 *value                                 /* #RETURN "Value= %lu\n" */
);


CLI b_errtype EXPORT BestTimCheckStatusGet(            /* @tcsget */
    b_handletype         handle,
    b_tcstatustype tcstatus,                     /* @stat */
    b_int32 *            value                         /* #RETURN "Value= %08lx\\h\n" */
    );


CLI b_errtype EXPORT BestTimCheckStatusClear(          /* @tcsclear */
    b_handletype handle
    );


CLI b_errtype EXPORT BestTimCheckPropSet(      /* @tcprpset */
    b_handletype          handle,
    b_tcproptype    tcprop,                    /* @prop */
    b_int32               value                /* @val */
    );

CLI b_errtype EXPORT BestTimCheckPropGet(      /* @tcprpget */
    b_handletype    handle,
    b_tcproptype    tcprop,                    /* @prop */
    b_int32         *value                      /* #RETURN "Value= %lu\n"*/
    );

CLI b_errtype EXPORT BestTimCheckGenPropSet(   /* @tcgprpset */
    b_handletype          handle,
    b_tcgenproptype    tcprop,                 /* @prop */
    b_int32               value                /* @val */
    );

CLI b_errtype EXPORT BestTimCheckGenPropGet(   /* @tcgprpget */
    b_handletype    handle,
    b_tcgenproptype    tcprop,                 /* @prop */
    b_int32         *value                     /* #RETURN "Value= %lu\n"*/
    );

CLI b_errtype EXPORT BestTimCheckProg(         /* @tcprog */
    b_handletype          handle
    );

CLI b_errtype EXPORT BestTimCheckRead(         /* @tcread */
    b_handletype          handle
    );

CLI b_errtype EXPORT BestTimCheckBitPosGet(          /* @tcbitposget */
				 b_handletype handle,
				 b_signaltype signal,  /* @sig */
				 b_int32 *bitpos,      /* #RETURN "bitpos: %d\n" */
				 b_int32 *length       /* #RETURN "Len: %d\n" */
				 );

CLI b_errtype EXPORT BestTimCheckIndexBitPosGet (	 /* @tcibitposget */
  			b_handletype	handle,
			b_int32 index,                      /* @index */ 
			b_int32 *bitpos                  /* #RETURN "bitpos=%lu\n" */
			);

CLI b_errtype EXPORT BestTimCheckSignalGet(             /* @tcsigget */
                        b_handletype handle,
                        b_int32 bitposition,        /* @pos */
                        b_signaltype * signal,      /* #RETURN "" */
                        b_charptrtype * signalname, /* #RETURN "Signal: %s" */
                        b_int32 * index,            /* #RETURN "[%d] " */
                        b_int32 * len,              /* #RETURN "length=%d " */
                        b_tcstatustype *accureg     /* #RETURN "accureg=%s\n" */
);



CLI b_errtype EXPORT BestTimCheckResultGet (	  /* @tcresultget */
  			b_handletype	handle,
			b_ccharptrtype *errortext /* #RETURN "%s\n" */
			);

CLI b_errtype EXPORT BestTimCheckErrResultGet (	  /* @tceresultget */
  			b_handletype	handle,
                        b_int32 accu1,  /* @accu1 $0 */ 
                        b_int32 accu2,  /* @accu2 $0 */
                        b_int32 accu3,  /* @accu3 $0 */
                        b_int32 accu4,  /* @accu4 $0 */
                        b_int32 status, /* @stat  $0 */
			b_ccharptrtype *errortext /* #RETURN "%s\n" */
			);

#ifdef __cplusplus
}
#endif

#endif

